/* skeleton.hpp */
#ifndef SKELETON_GUARD
#define SKELETON_GUARD

#include "afmm/include/mfmm.h"
#include "afmm/include/skeldt.h"
#include "afmm/include/genrl.h"
#include "afmm/include/field.h"
#include "afmm/include/flags.h"

FIELD<float>* computeDT(FIELD<float> *im);
FIELD<float>* do_one_pass(FIELD<float>* fi,FLAGS* flagsi,FIELD<std::multimap<float,int> >* origs,int N,int dir,ModifiedFastMarchingMethod::METHOD meth,float& length);
void postprocess(FIELD<float>* grad,FIELD<char>* skel,float level);
void comp_grad2(FLAGS* forig,FIELD<float>* cnt1,FIELD<float>* cnt2,FIELD<float>* grad);
FIELD<float>* saliencyThreshold(FIELD<float>* distMap, FIELD<float> *grad);

#endif
